import { Link } from 'react-router-dom';
import { 
  FaGithub, FaDiscord, FaLinkedin, FaReddit, FaInstagram, 
  FaFacebook, FaPinterest, FaYoutube, FaTwitch 
} from 'react-icons/fa';
import { FaXTwitter } from 'react-icons/fa6';

const Footer = () => {
  const currentYear = new Date().getFullYear();

  return (
    <footer className="bg-gradient-to-b from-gray-900 to-black border-t border-gray-800 mt-20">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-16">
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-6 gap-12 mb-12">
          {/* Brand Section */}
          <div className="lg:col-span-2">
            <h3 className="text-3xl font-bold bg-gradient-to-r from-turquoise to-gold bg-clip-text text-transparent mb-4">
              Vibe Coding Bros©
            </h3>
            <p className="text-gray-400 mb-6 leading-relaxed">
              The ultimate developer community platform - Share apps, find jobs, compete in challenges, 
              learn new skills, and connect with fellow coders worldwide.
            </p>
            
            {/* Social Icons - Colored */}
            <div className="flex flex-wrap gap-3">
              <a 
                href="https://github.com" 
                target="_blank" 
                rel="noopener noreferrer"
                className="group relative"
                aria-label="GitHub"
              >
                <div className="w-10 h-10 rounded-full bg-[#333] hover:scale-110 transition-all duration-300 flex items-center justify-center shadow-lg">
                  <FaGithub className="text-xl text-white" />
                </div>
              </a>
              
              <a 
                href="https://twitter.com" 
                target="_blank" 
                rel="noopener noreferrer"
                className="group relative"
                aria-label="X (Twitter)"
              >
                <div className="w-10 h-10 rounded-full bg-black hover:scale-110 transition-all duration-300 flex items-center justify-center shadow-lg">
                  <FaXTwitter className="text-xl text-white" />
                </div>
              </a>
              
              <a 
                href="https://discord.gg" 
                target="_blank" 
                rel="noopener noreferrer"
                className="group relative"
                aria-label="Discord"
              >
                <div className="w-10 h-10 rounded-full bg-[#5865F2] hover:scale-110 transition-all duration-300 flex items-center justify-center shadow-lg">
                  <FaDiscord className="text-xl text-white" />
                </div>
              </a>
              
              <a 
                href="https://linkedin.com" 
                target="_blank" 
                rel="noopener noreferrer"
                className="group relative"
                aria-label="LinkedIn"
              >
                <div className="w-10 h-10 rounded-full bg-[#0077B5] hover:scale-110 transition-all duration-300 flex items-center justify-center shadow-lg">
                  <FaLinkedin className="text-xl text-white" />
                </div>
              </a>
              
              <a 
                href="https://reddit.com" 
                target="_blank" 
                rel="noopener noreferrer"
                className="group relative"
                aria-label="Reddit"
              >
                <div className="w-10 h-10 rounded-full bg-[#FF4500] hover:scale-110 transition-all duration-300 flex items-center justify-center shadow-lg">
                  <FaReddit className="text-xl text-white" />
                </div>
              </a>
              
              <a 
                href="https://instagram.com" 
                target="_blank" 
                rel="noopener noreferrer"
                className="group relative"
                aria-label="Instagram"
              >
                <div className="w-10 h-10 rounded-full bg-gradient-to-tr from-[#833AB4] via-[#FD1D1D] to-[#FCAF45] hover:scale-110 transition-all duration-300 flex items-center justify-center shadow-lg">
                  <FaInstagram className="text-xl text-white" />
                </div>
              </a>
              
              <a 
                href="https://facebook.com" 
                target="_blank" 
                rel="noopener noreferrer"
                className="group relative"
                aria-label="Facebook"
              >
                <div className="w-10 h-10 rounded-full bg-[#1877F2] hover:scale-110 transition-all duration-300 flex items-center justify-center shadow-lg">
                  <FaFacebook className="text-xl text-white" />
                </div>
              </a>
              
              <a 
                href="https://pinterest.com" 
                target="_blank" 
                rel="noopener noreferrer"
                className="group relative"
                aria-label="Pinterest"
              >
                <div className="w-10 h-10 rounded-full bg-[#E60023] hover:scale-110 transition-all duration-300 flex items-center justify-center shadow-lg">
                  <FaPinterest className="text-xl text-white" />
                </div>
              </a>
              
              <a 
                href="https://youtube.com" 
                target="_blank" 
                rel="noopener noreferrer"
                className="group relative"
                aria-label="YouTube"
              >
                <div className="w-10 h-10 rounded-full bg-[#FF0000] hover:scale-110 transition-all duration-300 flex items-center justify-center shadow-lg">
                  <FaYoutube className="text-xl text-white" />
                </div>
              </a>
              
              <a 
                href="https://twitch.tv" 
                target="_blank" 
                rel="noopener noreferrer"
                className="group relative"
                aria-label="Twitch"
              >
                <div className="w-10 h-10 rounded-full bg-[#9146FF] hover:scale-110 transition-all duration-300 flex items-center justify-center shadow-lg">
                  <FaTwitch className="text-xl text-white" />
                </div>
              </a>
            </div>
          </div>

          {/* Platform */}
          <div>
            <h4 className="text-white font-bold text-lg mb-4 border-b border-gray-700 pb-2">Platform</h4>
            <ul className="space-y-3">
              <li>
                <Link to="/community" className="text-gray-400 hover:text-turquoise-400 transition-colors text-sm">
                  Community
                </Link>
              </li>
              <li>
                <Link to="/workflows" className="text-gray-400 hover:text-turquoise-400 transition-colors text-sm">
                  Workflows
                </Link>
              </li>
              <li>
                <Link to="/models" className="text-gray-400 hover:text-turquoise-400 transition-colors text-sm">
                  AI Models
                </Link>
              </li>
              <li>
                <Link to="/showcase" className="text-gray-400 hover:text-turquoise-400 transition-colors text-sm">
                  Showcase
                </Link>
              </li>
              <li>
                <Link to="/challenges" className="text-gray-400 hover:text-turquoise-400 transition-colors text-sm">
                  Challenges
                </Link>
              </li>
            </ul>
          </div>

          {/* Opportunities */}
          <div>
            <h4 className="text-white font-bold text-lg mb-4 border-b border-gray-700 pb-2">Opportunities</h4>
            <ul className="space-y-3">
              <li>
                <Link to="/jobs" className="text-gray-400 hover:text-turquoise-400 transition-colors text-sm">
                  Jobs Board
                </Link>
              </li>
              <li>
                <Link to="/classes" className="text-gray-400 hover:text-turquoise-400 transition-colors text-sm">
                  Vibe Classes
                </Link>
              </li>
              <li>
                <Link to="/marketplace" className="text-gray-400 hover:text-turquoise-400 transition-colors text-sm">
                  Marketplace
                </Link>
              </li>
              <li>
                <Link to="/referrals" className="text-gray-400 hover:text-turquoise-400 transition-colors text-sm">
                  Earn Rewards
                </Link>
              </li>
              <li>
                <Link to="/creator/dashboard" className="text-gray-400 hover:text-turquoise-400 transition-colors text-sm">
                  Creator Hub
                </Link>
              </li>
            </ul>
          </div>

          {/* Company */}
          <div>
            <h4 className="text-white font-bold text-lg mb-4 border-b border-gray-700 pb-2">Company</h4>
            <ul className="space-y-3">
              <li>
                <Link to="/summit" className="text-gray-400 hover:text-turquoise-400 transition-colors text-sm">
                  Summit Event
                </Link>
              </li>
              <li>
                <Link to="/pricing" className="text-gray-400 hover:text-turquoise-400 transition-colors text-sm">
                  Pricing Plans
                </Link>
              </li>
              <li>
                <Link to="/blog" className="text-gray-400 hover:text-turquoise-400 transition-colors text-sm">
                  Blog
                </Link>
              </li>
              <li>
                <Link to="/analytics" className="text-gray-400 hover:text-turquoise-400 transition-colors text-sm">
                  Analytics
                </Link>
              </li>
              <li>
                <Link to="/search" className="text-gray-400 hover:text-turquoise-400 transition-colors text-sm">
                  Search
                </Link>
              </li>
            </ul>
          </div>

          {/* Legal */}
          <div>
            <h4 className="text-white font-bold text-lg mb-4 border-b border-gray-700 pb-2">Legal</h4>
            <ul className="space-y-3">
              <li>
                <Link to="/privacy" className="text-gray-400 hover:text-turquoise-400 transition-colors text-sm">
                  Privacy Policy
                </Link>
              </li>
              <li>
                <Link to="/terms" className="text-gray-400 hover:text-turquoise-400 transition-colors text-sm">
                  Terms of Service
                </Link>
              </li>
              <li>
                <Link to="/cookies" className="text-gray-400 hover:text-turquoise-400 transition-colors text-sm">
                  Cookie Policy
                </Link>
              </li>
              <li>
                <Link to="/dmca" className="text-gray-400 hover:text-turquoise-400 transition-colors text-sm">
                  DMCA Policy
                </Link>
              </li>
              <li>
                <Link to="/refund-policy" className="text-gray-400 hover:text-turquoise-400 transition-colors text-sm">
                  Refund Policy
                </Link>
              </li>
            </ul>
          </div>
        </div>

        {/* Bottom Bar */}
        <div className="border-t border-gray-800 pt-8">
          <div className="flex flex-col md:flex-row justify-between items-center gap-4">
            <p className="text-gray-500 text-sm">
              &copy; {currentYear} Vibe Coding Bros©. All rights reserved.
            </p>
            <div className="flex gap-6 text-sm">
              <Link to="/terms" className="text-gray-500 hover:text-turquoise-400 transition-colors">
                Terms
              </Link>
              <Link to="/privacy" className="text-gray-500 hover:text-turquoise-400 transition-colors">
                Privacy
              </Link>
              <Link to="/dmca" className="text-gray-500 hover:text-turquoise-400 transition-colors">
                DMCA
              </Link>
              <Link to="/refund-policy" className="text-gray-500 hover:text-turquoise-400 transition-colors">
                Refunds
              </Link>
            </div>
          </div>
        </div>
      </div>
    </footer>
  );
};

export default Footer;
