import React from 'react';
import { useNavigate } from 'react-router-dom';
import { FaComments } from 'react-icons/fa';
import { useAuth } from '../context/AuthContext';
import api from '../services/api';

const MessageButton = ({ userId, username, size = 'normal', className = '' }) => {
  const navigate = useNavigate();
  const { isAuthenticated, user } = useAuth();

  const handleMessage = async (e) => {
    e.stopPropagation();
    e.preventDefault();

    if (!isAuthenticated) {
      navigate('/signin');
      return;
    }

    if (user?._id === userId) {
      return; // Can't message yourself
    }

    try {
      const response = await api.get(`/messages/conversations/${userId}`);
      navigate('/messages', { state: { conversation: response.data.data } });
    } catch (error) {
      console.error('Error starting conversation:', error);
    }
  };

  if (!isAuthenticated || user?._id === userId) {
    return null;
  }

  const buttonSizes = {
    small: 'px-2 py-1 text-sm',
    normal: 'px-3 py-2',
    large: 'px-4 py-3 text-lg',
  };

  return (
    <button
      onClick={handleMessage}
      className={`bg-light-sea-green text-white rounded-lg hover:bg-opacity-90 transition-colors flex items-center gap-2 ${buttonSizes[size]} ${className}`}
      title={`Message ${username}`}
    >
      <FaComments />
      <span>Message</span>
    </button>
  );
};

export default MessageButton;
