import ModelCard from './ModelCard';

export default function ModelCardsGrid({ 
  models, 
  viewMode = 'grid',
  selectedModels = [],
  onToggleSelect,
  onOpenDetail,
  onTestModel 
}) {
  return (
    <div className={viewMode === 'grid' ? 'grid sm:grid-cols-2 lg:grid-cols-3 gap-6' : 'space-y-4'}>
      {models.map((m, idx) => (
        <ModelCard 
          key={m.model || idx} 
          model={m}
          viewMode={viewMode}
          isSelected={selectedModels.some(sm => sm.model === m.model)}
          onToggleSelect={onToggleSelect}
          onOpenDetail={onOpenDetail}
          onTestModel={onTestModel}
        />
      ))}
    </div>
  );
}
