import ModelCard from './ModelCard';

export default function ModelList({ models }) {
  return (
    <div className="space-y-4">
      {models.map((m, idx) => (
        <div key={m.model || idx} className="card glass-effect p-4">
          <div className="flex items-start gap-4">
            <div className="card-media">
              <img src={m.companyIcon} alt={m.creator} className="w-full h-full object-contain" />
            </div>
            <div className="flex-1">
              <h3 className="text-xl font-semibold text-white leading-tight">{m.model}</h3>
              <div className="text-sm text-gray-400">{m.creator} • {m.paramSize || '—'}</div>
              <p className="mt-3 text-sm text-gray-300">{m.description || ''}</p>
              <div className="mt-4">
                <ModelCard model={m} />
              </div>
            </div>
          </div>
        </div>
      ))}
    </div>
  );
}
