import React from "react";

const CTAButton = ({ color, children, ...props }) => {
  // color: 'turquoise' | 'gold' | 'black' | 'cream'
  const colorMap = {
    turquoise: "bg-[#20B2AA] text-black hover:bg-[#1aa39a]",
    gold: "bg-[#FFD700] text-black hover:bg-[#e6c200]",
    black: "bg-black text-cream hover:bg-gray-900",
    cream: "bg-[#FFFDE7] text-black hover:bg-[#f7f3d7] border border-gray-200",
  };
  return (
    <button
      className={`w-full md:w-auto py-3 px-8 text-lg font-bold rounded transition-colors duration-200 shadow-lg focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-[#20B2AA] ${
        colorMap[color] || colorMap.turquoise
      }`}
      {...props}
    >
      {children}
    </button>
  );
};

const PricingCTAButtons = () => (
  <div className="flex flex-col md:flex-row gap-6 max-w-xl mx-auto mt-10">
    <CTAButton color="cream">Free Tier</CTAButton>
    <CTAButton color="turquoise">Upgrade to Pro</CTAButton>
    <CTAButton color="gold">Become a Creator</CTAButton>
  </div>
);

export default PricingCTAButtons;
