const blogPosts = [
  {
    id: 1,
    title: "What is Vibe Coding? The Philosophy That's Changing How Developers Work",
    slug: "what-is-vibe-coding",
    excerpt: "Discover the revolutionary approach to coding that prioritizes flow state, community collaboration, and genuine enjoyment over rigid methodologies and burnout culture.",
    author: "Alex Rivera",
    date: "November 10, 2025",
    readTime: "5 min read",
    category: "Philosophy",
    image: "https://images.unsplash.com/photo-1498050108023-c5249f4df085?w=800&h=500&fit=crop",
    likes: 247,
    comments: 34,
    featured: true,
    content: `<p>Vibe Coding is about prioritizing sustainable flow, creative collaboration, and building a development culture that avoids burnout. It's a blend of practical productivity techniques and community-driven support.</p>`
  },
  {
    id: 2,
    title: "5 Ways Vibe Coding Transforms Your Development Workflow",
    slug: "5-ways-vibe-coding-transforms-workflow",
    excerpt: "From music-driven coding sessions to async collaboration, learn practical techniques to implement vibe coding principles in your daily development routine.",
    author: "Sarah Chen",
    date: "November 8, 2025",
    readTime: "5 min read",
    category: "Productivity",
    image: "https://images.unsplash.com/photo-1522071820081-009f0129c71c?w=800&h=500&fit=crop",
    likes: 189,
    comments: 28,
    content: `<p>Practical tips include structured deep work blocks, community code reviews, and leveraging automation to remove busywork.</p>`
  },
  {
    id: 3,
    title: "Building a Vibe Coding Community: Lessons from the Trenches",
    slug: "building-vibe-coding-community",
    excerpt: "Creating spaces where developers thrive isn't just about Slack channels and coffee. Here's what we learned building Vibe Coding Bros from the ground up.",
    author: "Marcus Johnson",
    date: "November 5, 2025",
    readTime: "5 min read",
    category: "Community",
    image: "https://images.unsplash.com/photo-1522202176988-66273c2fd55f?w=800&h=500&fit=crop",
    likes: 312,
    comments: 56,
    content: `<p>Community building requires intentional onboarding, recognition systems, and accessible channels for newcomers to participate.</p>`
  },
  {
    id: 4,
    title: "The AI Bubble Myth: Why This Time Is Actually Different",
    slug: "ai-bubble-myth-why-different",
    excerpt: "Critics claim we're in an AI bubble destined to burst like the dot-com era. But the fundamentals tell a different story—one backed by real infrastructure, actual revenue, and transformative productivity gains.",
    author: "Dr. Sarah Mitchell",
    date: "January 12, 2026",
    readTime: "6 min read",
    category: "AI Insights",
    image: "https://images.unsplash.com/photo-1677442136019-21780ecad995?w=800&h=500&fit=crop",
    likes: 428,
    comments: 89,
    featured: false,
    content: `
      <p>The whispers of an "AI bubble" grow louder every quarter as valuations soar and every company pivots to showcase their AI credentials. But comparing today's AI revolution to the dot-com bubble reveals more differences than similarities.</p>
      
      <p>The dot-com era was built on speculation—companies with no revenue, no path to profitability, and websites that barely worked. Today's AI infrastructure is fundamentally different. Companies like OpenAI, Anthropic, and Mistral are generating hundreds of millions in actual revenue. Enterprises are seeing measurable ROI from AI implementations, from customer service automation saving millions to code generation boosting developer productivity by 30-55%.</p>
      
      <p>The infrastructure is real, too. NVIDIA's H100 GPUs aren't vaporware—they're physical chips powering real workloads. Microsoft's $10 billion investment in OpenAI isn't blind speculation; it's backed by Azure's AI services generating billions in annual revenue. The difference is tangible value creation, not just promise.</p>
      
      <p>Yes, there's hype. Yes, some valuations are stretched. But underneath lies legitimate technological advancement that's reshaping how we work, create, and solve problems. The question isn't whether AI is a bubble—it's how sustainably we can scale these genuine breakthroughs without repeating past mistakes. The fundamentals suggest we're witnessing transformation, not speculation.</p>
    `
  },
  {
    id: 5,
    title: "The Future of AI: From Agents to Ambient Intelligence",
    slug: "future-of-ai-agents-ambient-intelligence",
    excerpt: "AI is evolving beyond chatbots and image generators. The next frontier? Autonomous agents and ambient intelligence that seamlessly integrate into every aspect of our digital and physical lives.",
    author: "Alex Chen",
    date: "January 11, 2026",
    readTime: "7 min read",
    category: "AI Insights",
    image: "https://images.unsplash.com/photo-1620712943543-bcc4688e7485?w=800&h=500&fit=crop",
    likes: 512,
    comments: 103,
    featured: false,
    content: `
      <p>We're standing at the threshold of AI's next evolutionary leap. While today's LLMs have captivated the world with their ability to write, code, and reason, the future belongs to something more profound: autonomous agents and ambient intelligence that operate invisibly in the background of our lives.</p>
      
      <p>Agentic AI represents a paradigm shift from reactive tools to proactive collaborators. Instead of waiting for prompts, these systems will understand context, anticipate needs, and execute multi-step tasks autonomously. Imagine an AI that doesn't just help you write code—it monitors your entire development workflow, suggests architectural improvements, catches bugs before they reach production, and even negotiates with other AI agents to coordinate deployments across teams.</p>
      
      <p>Beyond individual agents, we're moving toward ambient intelligence—AI woven into the fabric of our environment. Your home won't just respond to commands; it will learn your routines, optimize energy usage, and coordinate with your calendar to prepare your morning coffee exactly when you wake up. Your workspace will adapt in real-time, adjusting lighting, noise levels, and task prioritization based on your cognitive state and deadlines.</p>
      
      <p>The challenges are immense: privacy concerns, ethical guardrails, energy consumption, and ensuring these systems remain aligned with human values. But the trajectory is clear. AI is transitioning from being a tool we use to an intelligent layer that enhances every interaction we have with technology. The future isn't about smarter chatbots—it's about invisible intelligence that makes our lives more productive, creative, and human.</p>
    `
  },
  {
    id: 6,
    title: "LLM Agentic Security: The New Frontier of AI Vulnerabilities",
    slug: "llm-agentic-security-new-frontier",
    excerpt: "As AI agents gain autonomy and real-world capabilities, a new class of security threats emerges. Prompt injection is just the beginning—agentic AI introduces attack vectors we've never seen before.",
    author: "Marcus Rodriguez",
    date: "January 10, 2026",
    readTime: "6 min read",
    category: "Security",
    image: "https://images.unsplash.com/photo-1550751827-4bd374c3f58b?w=800&h=500&fit=crop",
    likes: 387,
    comments: 67,
    featured: false,
    content: `
      <p>The rise of autonomous AI agents has unlocked incredible productivity—and equally incredible security risks. While we've spent years hardening traditional software against SQL injection and XSS attacks, agentic AI introduces vulnerabilities that exploit the very intelligence that makes these systems valuable.</p>
      
      <p>Prompt injection attacks are the most visible threat: malicious instructions embedded in seemingly innocent content that trick AI agents into executing unintended actions. Imagine an AI email assistant that, while reading a phishing email, encounters hidden instructions to forward sensitive documents to an attacker. Traditional security boundaries dissolve when the AI itself becomes the attack vector.</p>
      
      <p>But the threat landscape extends far beyond prompt injection. Agent-to-agent communication creates new exploitation surfaces. If your AI assistant delegates tasks to other specialized agents, an attacker who compromises one agent can potentially poison the entire ecosystem. Model extraction attacks allow adversaries to steal the capabilities of proprietary models by cleverly querying them. Data exfiltration becomes trivial when an AI can naturally justify accessing and sharing information.</p>
      
      <p>Defending against these threats requires rethinking security from first principles. We need sandboxed execution environments for agent actions, robust input validation that understands semantic context, continuous monitoring of agent behavior for anomalies, and kill-switches that can instantly revoke agent permissions. The security community must move fast—because every day, more critical systems are being handed over to agents operating with minimal oversight. The question isn't whether agentic AI will be exploited, but how quickly we can build defenses before the first major breach.</p>
    `
  }
];

export default blogPosts;
