import { useEffect } from 'react';
import { useLocation } from 'react-router-dom';

/**
 * Custom hook to track page views with Google Analytics
 * Updates meta tags dynamically based on route
 */
export const usePageTracking = (pageTitle, pageDescription) => {
  const location = useLocation();

  useEffect(() => {
    // Track page view
    if (typeof window.gtag !== 'undefined') {
      window.gtag('config', 'G-F8JZFPHQHP', {
        page_path: location.pathname + location.search,
        page_title: pageTitle,
      });
    }

    // Update document title
    if (pageTitle) {
      document.title = `${pageTitle} | Vibe Coding Bros`;
    }

    // Update meta description
    if (pageDescription) {
      const metaDescription = document.querySelector('meta[name="description"]');
      if (metaDescription) {
        metaDescription.setAttribute('content', pageDescription);
      }
    }

    // Update Open Graph tags
    if (pageTitle) {
      const ogTitle = document.querySelector('meta[property="og:title"]');
      if (ogTitle) {
        ogTitle.setAttribute('content', pageTitle);
      }
    }

    if (pageDescription) {
      const ogDescription = document.querySelector('meta[property="og:description"]');
      if (ogDescription) {
        ogDescription.setAttribute('content', pageDescription);
      }
    }
  }, [location, pageTitle, pageDescription]);
};
