import { useParams, Link } from 'react-router-dom';
import blogPosts from '../data/blogPosts';
import { Calendar, Clock } from 'lucide-react';

const BlogPost = () => {
  const { slug } = useParams();
  const post = blogPosts.find((p) => p.slug === slug);

  if (!post) {
    return (
      <div className="min-h-screen flex items-center justify-center">
        <div className="text-center">
          <h2 className="text-2xl font-bold mb-4">Post not found</h2>
          <p className="text-gray-600 mb-6">We couldn't find the blog post you're looking for.</p>
          <Link to="/blog" className="text-blue-600 hover:underline">Back to Blog</Link>
        </div>
      </div>
    );
  }

  return (
    <div className="min-h-screen bg-slate-50 pt-20">
      <div className="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
        <div className="bg-white rounded-2xl shadow p-8">
          <div className="mb-6">
            <img src={post.image} alt={post.title} className="w-full h-64 object-cover rounded-lg" />
          </div>
          <div className="text-sm text-gray-500 flex items-center gap-4 mb-4">
            <span className="bg-blue-100 text-blue-700 px-3 py-1 rounded-full font-medium">{post.category}</span>
            <div className="flex items-center gap-1"><Calendar className="w-4 h-4" /> <span>{post.date}</span></div>
            <div className="flex items-center gap-1"><Clock className="w-4 h-4" /> <span>{post.readTime}</span></div>
          </div>
          <h1 className="text-3xl font-bold mb-4">{post.title}</h1>
          <p className="text-gray-700 mb-6">{post.excerpt}</p>

          <div className="prose max-w-none" dangerouslySetInnerHTML={{ __html: post.content }} />

          <div className="mt-8 flex items-center justify-between">
            <div className="flex items-center gap-3">
              <div className="w-10 h-10 bg-gradient-to-br from-blue-500 to-purple-600 rounded-full flex items-center justify-center text-white font-bold">{post.author.charAt(0)}</div>
              <div>
                <p className="text-sm font-medium text-gray-900">{post.author}</p>
                <p className="text-xs text-gray-500">Author</p>
              </div>
            </div>
            <Link to="/blog" className="text-blue-600 hover:underline">Back to Blog</Link>
          </div>
        </div>
      </div>
    </div>
  );
};

export default BlogPost;
