import { Link } from 'react-router-dom';

const CookiePolicy = () => {
  return (
    <div className="min-h-screen bg-gray-900 py-12">
      <div className="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="bg-gray-800 rounded-lg shadow-xl p-8">
          <h1 className="text-4xl font-bold text-gradient mb-4">Cookie Policy</h1>
          <p className="text-gray-400 mb-8">Last updated: November 9, 2025</p>

          <div className="prose prose-invert max-w-none">
            <section className="mb-8">
              <h2 className="text-2xl font-semibold text-white mb-4">1. What Are Cookies?</h2>
              <p className="text-gray-300 mb-4">
                Cookies are small text files stored on your device when you visit websites. They help websites remember your preferences, improve functionality, and provide analytics about usage.
              </p>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-semibold text-white mb-4">2. How We Use Cookies</h2>
              <p className="text-gray-300 mb-4">
                VibeCodingBros uses cookies to:
              </p>
              <ul className="list-disc list-inside text-gray-300 mb-4 space-y-2">
                <li>Keep you logged in to your account</li>
                <li>Remember your preferences and settings</li>
                <li>Understand how you use our platform</li>
                <li>Improve platform performance and security</li>
                <li>Provide personalized content and features</li>
                <li>Analyze traffic and usage patterns</li>
              </ul>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-semibold text-white mb-4">3. Types of Cookies We Use</h2>

              <div className="bg-gray-700 p-6 rounded-lg mb-6">
                <h3 className="text-xl font-semibold text-white mb-3">3.1 Essential Cookies (Required)</h3>
                <p className="text-gray-300 mb-3">
                  These cookies are necessary for the platform to function. You cannot opt out of these cookies.
                </p>
                <table className="w-full text-gray-300 mb-4">
                  <thead>
                    <tr className="border-b border-gray-600">
                      <th className="text-left py-2">Cookie Name</th>
                      <th className="text-left py-2">Purpose</th>
                      <th className="text-left py-2">Duration</th>
                    </tr>
                  </thead>
                  <tbody>
                    <tr className="border-b border-gray-600">
                      <td className="py-2"><code>session</code></td>
                      <td className="py-2">Maintains your login session</td>
                      <td className="py-2">24 hours</td>
                    </tr>
                    <tr className="border-b border-gray-600">
                      <td className="py-2"><code>csrf_token</code></td>
                      <td className="py-2">Security protection</td>
                      <td className="py-2">Session</td>
                    </tr>
                    <tr className="border-b border-gray-600">
                      <td className="py-2"><code>auth_token</code></td>
                      <td className="py-2">Authentication state</td>
                      <td className="py-2">7 days</td>
                    </tr>
                  </tbody>
                </table>
              </div>

              <div className="bg-gray-700 p-6 rounded-lg mb-6">
                <h3 className="text-xl font-semibold text-white mb-3">3.2 Functional Cookies</h3>
                <p className="text-gray-300 mb-3">
                  These cookies enable enhanced functionality and personalization.
                </p>
                <table className="w-full text-gray-300 mb-4">
                  <thead>
                    <tr className="border-b border-gray-600">
                      <th className="text-left py-2">Cookie Name</th>
                      <th className="text-left py-2">Purpose</th>
                      <th className="text-left py-2">Duration</th>
                    </tr>
                  </thead>
                  <tbody>
                    <tr className="border-b border-gray-600">
                      <td className="py-2"><code>preferences</code></td>
                      <td className="py-2">Remembers your settings</td>
                      <td className="py-2">1 year</td>
                    </tr>
                    <tr className="border-b border-gray-600">
                      <td className="py-2"><code>theme</code></td>
                      <td className="py-2">Dark/light mode preference</td>
                      <td className="py-2">1 year</td>
                    </tr>
                    <tr className="border-b border-gray-600">
                      <td className="py-2"><code>language</code></td>
                      <td className="py-2">Language preference</td>
                      <td className="py-2">1 year</td>
                    </tr>
                  </tbody>
                </table>
              </div>

              <div className="bg-gray-700 p-6 rounded-lg mb-6">
                <h3 className="text-xl font-semibold text-white mb-3">3.3 Analytics Cookies</h3>
                <p className="text-gray-300 mb-3">
                  These cookies help us understand how visitors use our platform.
                </p>
                <table className="w-full text-gray-300 mb-4">
                  <thead>
                    <tr className="border-b border-gray-600">
                      <th className="text-left py-2">Service</th>
                      <th className="text-left py-2">Purpose</th>
                      <th className="text-left py-2">Duration</th>
                    </tr>
                  </thead>
                  <tbody>
                    <tr className="border-b border-gray-600">
                      <td className="py-2"><code>Google Analytics 4</code></td>
                      <td className="py-2">Usage statistics and analytics</td>
                      <td className="py-2">2 years</td>
                    </tr>
                    <tr className="border-b border-gray-600">
                      <td className="py-2"><code>_ga</code></td>
                      <td className="py-2">Distinguishes users</td>
                      <td className="py-2">2 years</td>
                    </tr>
                    <tr className="border-b border-gray-600">
                      <td className="py-2"><code>_gid</code></td>
                      <td className="py-2">Distinguishes users</td>
                      <td className="py-2">24 hours</td>
                    </tr>
                  </tbody>
                </table>
                <p className="text-gray-300 text-sm">
                  Learn more: <a href="https://policies.google.com/technologies/cookies" className="text-turquoise hover:underline" target="_blank" rel="noopener noreferrer">Google's Cookie Policy</a>
                </p>
              </div>

              <div className="bg-gray-700 p-6 rounded-lg mb-6">
                <h3 className="text-xl font-semibold text-white mb-3">3.4 Third-Party Cookies</h3>
                <p className="text-gray-300 mb-3">
                  Some features use third-party services that may set their own cookies.
                </p>
                <table className="w-full text-gray-300 mb-4">
                  <thead>
                    <tr className="border-b border-gray-600">
                      <th className="text-left py-2">Service</th>
                      <th className="text-left py-2">Purpose</th>
                      <th className="text-left py-2">Privacy Policy</th>
                    </tr>
                  </thead>
                  <tbody>
                    <tr className="border-b border-gray-600">
                      <td className="py-2">Stripe</td>
                      <td className="py-2">Payment processing</td>
                      <td className="py-2"><a href="https://stripe.com/privacy" className="text-turquoise hover:underline" target="_blank" rel="noopener noreferrer">View</a></td>
                    </tr>
                    <tr className="border-b border-gray-600">
                      <td className="py-2">Google Fonts</td>
                      <td className="py-2">Font delivery</td>
                      <td className="py-2"><a href="https://policies.google.com/privacy" className="text-turquoise hover:underline" target="_blank" rel="noopener noreferrer">View</a></td>
                    </tr>
                  </tbody>
                </table>
              </div>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-semibold text-white mb-4">4. Managing Cookies</h2>
              
              <h3 className="text-xl font-semibold text-white mb-3">4.1 Browser Settings</h3>
              <p className="text-gray-300 mb-4">
                Most browsers allow you to control cookies through settings. You can:
              </p>
              <ul className="list-disc list-inside text-gray-300 mb-4 space-y-2">
                <li>Block all cookies</li>
                <li>Block third-party cookies only</li>
                <li>Delete cookies after each session</li>
                <li>Make exceptions for specific websites</li>
              </ul>

              <h3 className="text-xl font-semibold text-white mb-3">4.2 Browser Instructions</h3>
              <div className="bg-gray-700 p-4 rounded-lg mb-4">
                <ul className="space-y-2 text-gray-300">
                  <li><strong>Chrome:</strong> Settings → Privacy and security → Cookies and other site data</li>
                  <li><strong>Firefox:</strong> Options → Privacy & Security → Cookies and Site Data</li>
                  <li><strong>Safari:</strong> Preferences → Privacy → Manage Website Data</li>
                  <li><strong>Edge:</strong> Settings → Cookies and site permissions → Cookies and site data</li>
                </ul>
              </div>

              <h3 className="text-xl font-semibold text-white mb-3">4.3 Google Analytics Opt-Out</h3>
              <p className="text-gray-300 mb-4">
                Install the <a href="https://tools.google.com/dlpage/gaoptout" className="text-turquoise hover:underline" target="_blank" rel="noopener noreferrer">Google Analytics Opt-out Browser Add-on</a>
              </p>

              <h3 className="text-xl font-semibold text-white mb-3">4.4 Do Not Track</h3>
              <p className="text-gray-300 mb-4">
                We honor Do Not Track (DNT) browser signals. When DNT is enabled, we disable non-essential analytics cookies.
              </p>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-semibold text-white mb-4">5. Impact of Blocking Cookies</h2>
              <p className="text-gray-300 mb-4">
                If you block cookies, some features may not work properly:
              </p>
              <ul className="list-disc list-inside text-gray-300 mb-4 space-y-2">
                <li>❌ <strong>Essential cookies:</strong> Cannot stay logged in, security features disabled</li>
                <li>⚠️ <strong>Functional cookies:</strong> Settings not remembered, default preferences used</li>
                <li>✅ <strong>Analytics cookies:</strong> No impact on functionality</li>
                <li>✅ <strong>Third-party cookies:</strong> Platform works normally</li>
              </ul>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-semibold text-white mb-4">6. Local Storage and Session Storage</h2>
              <p className="text-gray-300 mb-4">
                In addition to cookies, we use browser storage technologies:
              </p>
              
              <h3 className="text-xl font-semibold text-white mb-3">Local Storage</h3>
              <ul className="list-disc list-inside text-gray-300 mb-4 space-y-2">
                <li><code>token</code> - Authentication token (persistent login)</li>
                <li><code>user_preferences</code> - UI settings and preferences</li>
                <li><code>draft_content</code> - Auto-saved drafts</li>
              </ul>

              <h3 className="text-xl font-semibold text-white mb-3">Session Storage</h3>
              <ul className="list-disc list-inside text-gray-300 mb-4 space-y-2">
                <li><code>csrf_token</code> - Security token (cleared on browser close)</li>
                <li><code>temp_data</code> - Temporary form data</li>
              </ul>

              <p className="text-gray-300 mb-4">
                You can clear these through your browser's developer tools or site settings.
              </p>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-semibold text-white mb-4">7. Mobile Apps</h2>
              <p className="text-gray-300 mb-4">
                Our Progressive Web App (PWA) may use similar technologies. You can manage these through:
              </p>
              <ul className="list-disc list-inside text-gray-300 mb-4 space-y-2">
                <li><strong>iOS:</strong> Settings → Safari → Advanced → Website Data</li>
                <li><strong>Android:</strong> Settings → Apps → Browser → Storage → Clear Data</li>
              </ul>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-semibold text-white mb-4">8. Cookie Consent</h2>
              
              <h3 className="text-xl font-semibold text-white mb-3">For EU Visitors (GDPR)</h3>
              <p className="text-gray-300 mb-4">
                We obtain consent before setting non-essential cookies. You can manage your consent preferences anytime.
              </p>

              <h3 className="text-xl font-semibold text-white mb-3">For California Visitors (CCPA)</h3>
              <p className="text-gray-300 mb-4">
                You have the right to opt-out of cookie-based tracking. We do not sell personal information collected via cookies.
              </p>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-semibold text-white mb-4">9. Updates to This Policy</h2>
              <p className="text-gray-300 mb-4">
                We may update this Cookie Policy to reflect changes in technology or legal requirements. Check the "Last updated" date at the top of this page.
              </p>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-semibold text-white mb-4">10. More Information</h2>
              <p className="text-gray-300 mb-4">
                Learn more about cookies:
              </p>
              <ul className="list-disc list-inside text-gray-300 mb-4 space-y-2">
                <li><a href="https://www.allaboutcookies.org/" className="text-turquoise hover:underline" target="_blank" rel="noopener noreferrer">All About Cookies</a></li>
                <li><a href="https://cookiepedia.co.uk/" className="text-turquoise hover:underline" target="_blank" rel="noopener noreferrer">Cookiepedia</a></li>
                <li><a href="https://www.youronlinechoices.com/" className="text-turquoise hover:underline" target="_blank" rel="noopener noreferrer">Your Online Choices</a></li>
              </ul>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-semibold text-white mb-4">11. Contact Us</h2>
              <p className="text-gray-300 mb-4">
                Questions about our use of cookies?
              </p>
              <ul className="list-none text-gray-300 mb-4 space-y-2">
                <li><strong>Email:</strong> privacy@vibecodingbros.com</li>
                <li><strong>Support:</strong> support@vibecodingbros.com</li>
                <li><strong>Website:</strong> vibecodingbros.com</li>
              </ul>
            </section>

            <div className="bg-turquoise/10 border border-turquoise p-6 rounded-lg">
              <h3 className="text-xl font-semibold text-white mb-3">Quick Summary</h3>
              <ul className="space-y-2 text-gray-300">
                <li>✅ We use cookies to keep you logged in and improve your experience</li>
                <li>✅ Essential cookies are required; others can be disabled</li>
                <li>✅ We use Google Analytics to understand usage (you can opt-out)</li>
                <li>✅ We honor Do Not Track signals</li>
                <li>✅ You control cookies through browser settings</li>
              </ul>
            </div>
          </div>

          <div className="mt-8 pt-8 border-t border-gray-700 flex justify-between">
            <Link to="/" className="text-turquoise hover:text-turquoise-light transition-colors">
              ← Back to Home
            </Link>
            <div className="space-x-4">
              <Link to="/privacy" className="text-turquoise hover:text-turquoise-light transition-colors">
                Privacy Policy
              </Link>
              <Link to="/terms" className="text-turquoise hover:text-turquoise-light transition-colors">
                Terms of Service
              </Link>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
};

export default CookiePolicy;
