import { Link } from 'react-router-dom';
import { FaShieldAlt, FaEnvelope, FaExclamationTriangle } from 'react-icons/fa';

const DMCA = () => {
  return (
    <div className="min-h-screen pt-24 pb-12 bg-gradient-to-br from-gray-900 via-gray-800 to-gray-900">
      <div className="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        {/* Header */}
        <div className="text-center mb-12">
          <div className="inline-flex items-center justify-center w-20 h-20 bg-gradient-to-r from-turquoise to-gold rounded-full mb-6">
            <FaShieldAlt className="text-3xl text-white" />
          </div>
          <h1 className="text-5xl font-bold text-white mb-4">DMCA Policy</h1>
          <p className="text-xl text-gray-400">Digital Millennium Copyright Act Compliance</p>
          <p className="text-sm text-gray-500 mt-2">Last Updated: January 13, 2026</p>
        </div>

        {/* Content */}
        <div className="bg-gray-800/50 rounded-2xl border border-gray-700 p-8 space-y-8">
          
          {/* Overview */}
          <section>
            <h2 className="text-2xl font-bold text-white mb-4">Copyright Infringement Notice</h2>
            <p className="text-gray-300 leading-relaxed">
              Vibe Coding Bros respects the intellectual property rights of others and expects our users to do the same. 
              We will respond to notices of alleged copyright infringement that comply with the Digital Millennium Copyright Act 
              ("DMCA") and other applicable intellectual property laws.
            </p>
          </section>

          {/* Filing a DMCA Notice */}
          <section className="border-t border-gray-700 pt-8">
            <h2 className="text-2xl font-bold text-white mb-4 flex items-center gap-2">
              <FaExclamationTriangle className="text-yellow-500" />
              Filing a DMCA Takedown Notice
            </h2>
            <p className="text-gray-300 mb-4">
              If you believe that content available on or through our platform infringes your copyright, 
              please send a DMCA notice containing the following information:
            </p>
            <ul className="space-y-3 text-gray-300">
              <li className="flex gap-3">
                <span className="text-turquoise-500 font-bold">1.</span>
                <span>A physical or electronic signature of the copyright owner or person authorized to act on their behalf</span>
              </li>
              <li className="flex gap-3">
                <span className="text-turquoise-500 font-bold">2.</span>
                <span>Identification of the copyrighted work claimed to have been infringed</span>
              </li>
              <li className="flex gap-3">
                <span className="text-turquoise-500 font-bold">3.</span>
                <span>Identification of the material that is claimed to be infringing, with sufficient detail to locate it on our platform</span>
              </li>
              <li className="flex gap-3">
                <span className="text-turquoise-500 font-bold">4.</span>
                <span>Your contact information (address, telephone number, and email address)</span>
              </li>
              <li className="flex gap-3">
                <span className="text-turquoise-500 font-bold">5.</span>
                <span>A statement that you have a good faith belief that use of the material is not authorized by the copyright owner</span>
              </li>
              <li className="flex gap-3">
                <span className="text-turquoise-500 font-bold">6.</span>
                <span>A statement that the information in the notice is accurate, and under penalty of perjury, that you are authorized to act on behalf of the copyright owner</span>
              </li>
            </ul>
          </section>

          {/* Contact Information */}
          <section className="border-t border-gray-700 pt-8">
            <h2 className="text-2xl font-bold text-white mb-4 flex items-center gap-2">
              <FaEnvelope className="text-turquoise-500" />
              DMCA Agent Contact
            </h2>
            <div className="bg-gray-700/50 rounded-xl p-6 border border-gray-600">
              <p className="text-gray-300 mb-4">Send your DMCA notice to our designated agent:</p>
              <div className="space-y-2 text-gray-300">
                <p><strong className="text-white">Email:</strong> dmca@vibecoding.com</p>
                <p><strong className="text-white">Subject Line:</strong> DMCA Takedown Request</p>
                <p className="text-sm text-gray-400 mt-4">
                  Please allow 2-3 business days for us to review and respond to your notice.
                </p>
              </div>
            </div>
          </section>

          {/* Counter-Notice */}
          <section className="border-t border-gray-700 pt-8">
            <h2 className="text-2xl font-bold text-white mb-4">Counter-Notice Procedure</h2>
            <p className="text-gray-300 mb-4">
              If you believe your content was removed by mistake or misidentification, you may file a counter-notice containing:
            </p>
            <ul className="space-y-3 text-gray-300">
              <li className="flex gap-3">
                <span className="text-turquoise-500 font-bold">•</span>
                <span>Your physical or electronic signature</span>
              </li>
              <li className="flex gap-3">
                <span className="text-turquoise-500 font-bold">•</span>
                <span>Identification of the material that was removed and its previous location</span>
              </li>
              <li className="flex gap-3">
                <span className="text-turquoise-500 font-bold">•</span>
                <span>A statement under penalty of perjury that you have a good faith belief the material was removed by mistake</span>
              </li>
              <li className="flex gap-3">
                <span className="text-turquoise-500 font-bold">•</span>
                <span>Your name, address, and telephone number</span>
              </li>
              <li className="flex gap-3">
                <span className="text-turquoise-500 font-bold">•</span>
                <span>A statement consenting to the jurisdiction of the Federal District Court for your judicial district</span>
              </li>
            </ul>
          </section>

          {/* Repeat Infringer Policy */}
          <section className="border-t border-gray-700 pt-8">
            <h2 className="text-2xl font-bold text-white mb-4">Repeat Infringer Policy</h2>
            <p className="text-gray-300">
              In accordance with the DMCA and other applicable law, we have adopted a policy of terminating, 
              in appropriate circumstances, users who are deemed to be repeat infringers. We may also, at our sole discretion, 
              limit access to the platform and/or terminate the accounts of any users who infringe any intellectual property 
              rights of others, whether or not there is any repeat infringement.
            </p>
          </section>

          {/* Important Notice */}
          <section className="border-t border-gray-700 pt-8">
            <div className="bg-yellow-900/20 border border-yellow-700/50 rounded-xl p-6">
              <h3 className="text-xl font-bold text-yellow-400 mb-3 flex items-center gap-2">
                <FaExclamationTriangle />
                Important Notice
              </h3>
              <p className="text-gray-300">
                Under Section 512(f) of the DMCA, any person who knowingly materially misrepresents that material 
                or activity is infringing may be subject to liability. Please do not make false claims.
              </p>
            </div>
          </section>

          {/* Back to Legal */}
          <div className="border-t border-gray-700 pt-8 text-center">
            <p className="text-gray-400 mb-4">Have questions about our policies?</p>
            <div className="flex gap-4 justify-center flex-wrap">
              <Link to="/terms" className="text-turquoise-500 hover:text-turquoise-400 transition-colors">
                Terms of Service
              </Link>
              <Link to="/privacy" className="text-turquoise-500 hover:text-turquoise-400 transition-colors">
                Privacy Policy
              </Link>
              <Link to="/refund-policy" className="text-turquoise-500 hover:text-turquoise-400 transition-colors">
                Refund Policy
              </Link>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
};

export default DMCA;
