import { Link } from 'react-router-dom';

const Privacy = () => {
  return (
    <div className="min-h-screen bg-gray-900 py-12">
      <div className="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="bg-gray-800 rounded-lg shadow-xl p-8">
          <h1 className="text-4xl font-bold text-gradient mb-4">Privacy Policy</h1>
          <p className="text-gray-400 mb-8">Last updated: November 9, 2025</p>

          <div className="prose prose-invert max-w-none">
            <section className="mb-8">
              <h2 className="text-2xl font-semibold text-white mb-4">1. Introduction</h2>
              <p className="text-gray-300 mb-4">
                Welcome to VibeCodingBros ("we," "our," or "us"). We respect your privacy and are committed to protecting your personal data. This privacy policy explains how we collect, use, disclose, and safeguard your information when you use our platform.
              </p>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-semibold text-white mb-4">2. Information We Collect</h2>
              
              <h3 className="text-xl font-semibold text-white mb-3">2.1 Information You Provide</h3>
              <ul className="list-disc list-inside text-gray-300 mb-4 space-y-2">
                <li><strong>Account Information:</strong> Name, email address, username, password, profile picture</li>
                <li><strong>Profile Data:</strong> Bio, skills, tech stack, social media links, portfolio URL</li>
                <li><strong>Content:</strong> Workflows, challenges, job postings, marketplace products, messages, comments</li>
                <li><strong>Payment Information:</strong> Processed securely through Stripe (we don't store card details)</li>
                <li><strong>Communications:</strong> Messages sent through our platform, support inquiries</li>
              </ul>

              <h3 className="text-xl font-semibold text-white mb-3">2.2 Automatically Collected Information</h3>
              <ul className="list-disc list-inside text-gray-300 mb-4 space-y-2">
                <li><strong>Usage Data:</strong> Pages viewed, features used, time spent, click patterns</li>
                <li><strong>Device Information:</strong> IP address, browser type, operating system, device identifiers</li>
                <li><strong>Cookies:</strong> Session cookies, analytics cookies, preference cookies (see Cookie Policy)</li>
                <li><strong>Analytics:</strong> Google Analytics 4 data for platform improvement</li>
              </ul>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-semibold text-white mb-4">3. How We Use Your Information</h2>
              <ul className="list-disc list-inside text-gray-300 mb-4 space-y-2">
                <li><strong>Provide Services:</strong> Account management, content delivery, messaging, payments</li>
                <li><strong>Improve Platform:</strong> Analytics, bug fixes, feature development, user experience</li>
                <li><strong>Communication:</strong> Transactional emails, notifications, updates, marketing (with consent)</li>
                <li><strong>Security:</strong> Fraud prevention, abuse detection, security monitoring</li>
                <li><strong>Legal Compliance:</strong> Terms enforcement, legal obligations, dispute resolution</li>
                <li><strong>Personalization:</strong> Recommended content, customized experience, relevant opportunities</li>
              </ul>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-semibold text-white mb-4">4. Information Sharing and Disclosure</h2>
              
              <h3 className="text-xl font-semibold text-white mb-3">We Share Information With:</h3>
              <ul className="list-disc list-inside text-gray-300 mb-4 space-y-2">
                <li><strong>Other Users:</strong> Public profile information, content you post, activity in public areas</li>
                <li><strong>Service Providers:</strong> Stripe (payments), Google Analytics (analytics), hosting providers, email services</li>
                <li><strong>Business Partners:</strong> With your consent, for opportunities like jobs or collaborations</li>
                <li><strong>Legal Requirements:</strong> When required by law, court order, or to protect rights and safety</li>
                <li><strong>Business Transfers:</strong> In case of merger, acquisition, or sale of assets</li>
              </ul>

              <h3 className="text-xl font-semibold text-white mb-3">We Do NOT:</h3>
              <ul className="list-disc list-inside text-gray-300 mb-4 space-y-2">
                <li>Sell your personal information to third parties</li>
                <li>Share your email with marketers without consent</li>
                <li>Use your private messages for advertising</li>
                <li>Share payment information (handled by Stripe)</li>
              </ul>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-semibold text-white mb-4">5. Data Security</h2>
              <p className="text-gray-300 mb-4">
                We implement industry-standard security measures to protect your data:
              </p>
              <ul className="list-disc list-inside text-gray-300 mb-4 space-y-2">
                <li><strong>Encryption:</strong> HTTPS/TLS encryption for data in transit</li>
                <li><strong>Authentication:</strong> JWT tokens, secure password hashing (bcrypt)</li>
                <li><strong>Rate Limiting:</strong> Protection against brute force attacks</li>
                <li><strong>CSRF Protection:</strong> Token-based protection for state-changing operations</li>
                <li><strong>Input Sanitization:</strong> Prevention of XSS and NoSQL injection attacks</li>
                <li><strong>Regular Audits:</strong> Security reviews and vulnerability assessments</li>
              </ul>
              <p className="text-gray-300 mb-4">
                However, no method of transmission over the Internet is 100% secure. We cannot guarantee absolute security.
              </p>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-semibold text-white mb-4">6. Your Rights and Choices</h2>
              <ul className="list-disc list-inside text-gray-300 mb-4 space-y-2">
                <li><strong>Access:</strong> Request a copy of your personal data</li>
                <li><strong>Correction:</strong> Update inaccurate or incomplete information</li>
                <li><strong>Deletion:</strong> Request deletion of your account and data</li>
                <li><strong>Export:</strong> Download your data in a portable format</li>
                <li><strong>Opt-Out:</strong> Unsubscribe from marketing emails (account emails required)</li>
                <li><strong>Cookie Control:</strong> Manage cookies through browser settings</li>
                <li><strong>Do Not Track:</strong> We honor Do Not Track browser signals</li>
              </ul>
              <p className="text-gray-300 mb-4">
                To exercise these rights, contact us at privacy@vibecodingbros.com
              </p>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-semibold text-white mb-4">7. Data Retention</h2>
              <p className="text-gray-300 mb-4">
                We retain your information for as long as necessary to provide services and comply with legal obligations:
              </p>
              <ul className="list-disc list-inside text-gray-300 mb-4 space-y-2">
                <li><strong>Active Accounts:</strong> Retained while account is active</li>
                <li><strong>Deleted Accounts:</strong> Personal data deleted within 30 days (some data retained for legal compliance)</li>
                <li><strong>Content:</strong> Public content may remain visible after account deletion (anonymized)</li>
                <li><strong>Backups:</strong> Backup copies deleted within 90 days</li>
                <li><strong>Legal Requirements:</strong> Some data retained longer for legal, tax, or regulatory purposes</li>
              </ul>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-semibold text-white mb-4">8. International Data Transfers</h2>
              <p className="text-gray-300 mb-4">
                Your information may be transferred to and processed in countries other than your own. We ensure appropriate safeguards are in place to protect your data in accordance with this privacy policy.
              </p>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-semibold text-white mb-4">9. Children's Privacy</h2>
              <p className="text-gray-300 mb-4">
                Our platform is not intended for children under 13. We do not knowingly collect personal information from children under 13. If you believe we have collected such information, please contact us immediately.
              </p>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-semibold text-white mb-4">10. Third-Party Services</h2>
              <p className="text-gray-300 mb-4">
                Our platform integrates with third-party services:
              </p>
              <ul className="list-disc list-inside text-gray-300 mb-4 space-y-2">
                <li><strong>Stripe:</strong> Payment processing (see Stripe's privacy policy)</li>
                <li><strong>Google Analytics:</strong> Usage analytics (see Google's privacy policy)</li>
                <li><strong>Social Media:</strong> Social login and sharing (see respective privacy policies)</li>
              </ul>
              <p className="text-gray-300 mb-4">
                We are not responsible for the privacy practices of these third parties.
              </p>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-semibold text-white mb-4">11. California Privacy Rights (CCPA)</h2>
              <p className="text-gray-300 mb-4">
                California residents have additional rights under the CCPA:
              </p>
              <ul className="list-disc list-inside text-gray-300 mb-4 space-y-2">
                <li>Right to know what personal information is collected</li>
                <li>Right to know if personal information is sold or disclosed</li>
                <li>Right to opt-out of the sale of personal information</li>
                <li>Right to deletion of personal information</li>
                <li>Right to non-discrimination for exercising CCPA rights</li>
              </ul>
              <p className="text-gray-300 mb-4">
                <strong>Note:</strong> We do not sell personal information.
              </p>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-semibold text-white mb-4">12. European Privacy Rights (GDPR)</h2>
              <p className="text-gray-300 mb-4">
                EU residents have rights under GDPR:
              </p>
              <ul className="list-disc list-inside text-gray-300 mb-4 space-y-2">
                <li>Right to access your personal data</li>
                <li>Right to rectification of inaccurate data</li>
                <li>Right to erasure ("right to be forgotten")</li>
                <li>Right to restrict processing</li>
                <li>Right to data portability</li>
                <li>Right to object to processing</li>
                <li>Right to withdraw consent</li>
              </ul>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-semibold text-white mb-4">13. Changes to This Policy</h2>
              <p className="text-gray-300 mb-4">
                We may update this privacy policy from time to time. We will notify you of significant changes by:
              </p>
              <ul className="list-disc list-inside text-gray-300 mb-4 space-y-2">
                <li>Posting the new policy on this page</li>
                <li>Updating the "Last updated" date</li>
                <li>Sending an email notification for material changes</li>
                <li>Displaying a prominent notice on the platform</li>
              </ul>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-semibold text-white mb-4">14. Contact Us</h2>
              <p className="text-gray-300 mb-4">
                If you have questions about this privacy policy or our data practices:
              </p>
              <ul className="list-none text-gray-300 mb-4 space-y-2">
                <li><strong>Email:</strong> privacy@vibecodingbros.com</li>
                <li><strong>Support:</strong> support@vibecodingbros.com</li>
                <li><strong>Website:</strong> vibecodingbros.com</li>
              </ul>
            </section>
          </div>

          <div className="mt-8 pt-8 border-t border-gray-700">
            <Link to="/" className="text-turquoise hover:text-turquoise-light transition-colors">
              ← Back to Home
            </Link>
          </div>
        </div>
      </div>
    </div>
  );
};

export default Privacy;
