import { Link } from 'react-router-dom';
import { FaMoneyBillWave, FaCalendarAlt, FaCheckCircle, FaTimesCircle } from 'react-icons/fa';

const RefundPolicy = () => {
  return (
    <div className="min-h-screen pt-24 pb-12 bg-gradient-to-br from-gray-900 via-gray-800 to-gray-900">
      <div className="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        {/* Header */}
        <div className="text-center mb-12">
          <div className="inline-flex items-center justify-center w-20 h-20 bg-gradient-to-r from-turquoise to-gold rounded-full mb-6">
            <FaMoneyBillWave className="text-3xl text-white" />
          </div>
          <h1 className="text-5xl font-bold text-white mb-4">Refund Policy</h1>
          <p className="text-xl text-gray-400">Our commitment to your satisfaction</p>
          <p className="text-sm text-gray-500 mt-2">Last Updated: January 13, 2026</p>
        </div>

        {/* Content */}
        <div className="bg-gray-800/50 rounded-2xl border border-gray-700 p-8 space-y-8">
          
          {/* Overview */}
          <section>
            <h2 className="text-2xl font-bold text-white mb-4">Refund Policy Overview</h2>
            <p className="text-gray-300 leading-relaxed">
              At Vibe Coding Bros, we strive to provide exceptional value through our platform, courses, marketplace items, 
              and services. This refund policy outlines the terms and conditions for refunds across all our offerings.
            </p>
          </section>

          {/* Subscription Refunds */}
          <section className="border-t border-gray-700 pt-8">
            <h2 className="text-2xl font-bold text-white mb-4 flex items-center gap-2">
              <FaCalendarAlt className="text-turquoise-500" />
              Subscription Refunds
            </h2>
            <div className="space-y-4">
              <div className="bg-gray-700/50 rounded-xl p-6 border border-gray-600">
                <h3 className="text-lg font-semibold text-white mb-3 flex items-center gap-2">
                  <FaCheckCircle className="text-green-500" />
                  Eligible for Refund
                </h3>
                <ul className="space-y-2 text-gray-300">
                  <li className="flex gap-2">
                    <span className="text-turquoise-500">•</span>
                    <span>Within 7 days of initial subscription purchase</span>
                  </li>
                  <li className="flex gap-2">
                    <span className="text-turquoise-500">•</span>
                    <span>Technical issues preventing platform access (verified by our team)</span>
                  </li>
                  <li className="flex gap-2">
                    <span className="text-turquoise-500">•</span>
                    <span>Duplicate charges or billing errors</span>
                  </li>
                </ul>
              </div>

              <div className="bg-gray-700/50 rounded-xl p-6 border border-gray-600">
                <h3 className="text-lg font-semibold text-white mb-3 flex items-center gap-2">
                  <FaTimesCircle className="text-red-500" />
                  Not Eligible for Refund
                </h3>
                <ul className="space-y-2 text-gray-300">
                  <li className="flex gap-2">
                    <span className="text-red-500">•</span>
                    <span>Partial month subscriptions</span>
                  </li>
                  <li className="flex gap-2">
                    <span className="text-red-500">•</span>
                    <span>After 7 days of initial purchase</span>
                  </li>
                  <li className="flex gap-2">
                    <span className="text-red-500">•</span>
                    <span>Violation of Terms of Service resulting in account suspension</span>
                  </li>
                </ul>
              </div>
            </div>
          </section>

          {/* Marketplace & Digital Products */}
          <section className="border-t border-gray-700 pt-8">
            <h2 className="text-2xl font-bold text-white mb-4">Marketplace & Digital Products</h2>
            <p className="text-gray-300 mb-4">
              Digital products (templates, code snippets, workflows, apps) purchased through our marketplace:
            </p>
            <ul className="space-y-3 text-gray-300">
              <li className="flex gap-3">
                <span className="text-turquoise-500 font-bold">•</span>
                <span><strong className="text-white">48-hour window:</strong> Request refund within 48 hours if product is defective or not as described</span>
              </li>
              <li className="flex gap-3">
                <span className="text-turquoise-500 font-bold">•</span>
                <span><strong className="text-white">Documentation required:</strong> Provide evidence of defects or misrepresentation</span>
              </li>
              <li className="flex gap-3">
                <span className="text-turquoise-500 font-bold">•</span>
                <span><strong className="text-white">No refunds:</strong> Once downloaded and used, unless proven defective</span>
              </li>
            </ul>
          </section>

          {/* Vibe Classes */}
          <section className="border-t border-gray-700 pt-8">
            <h2 className="text-2xl font-bold text-white mb-4">Vibe Classes</h2>
            <div className="bg-gray-700/50 rounded-xl p-6 border border-gray-600">
              <p className="text-gray-300 mb-4">Our online courses and workshops follow these guidelines:</p>
              <ul className="space-y-3 text-gray-300">
                <li className="flex gap-3">
                  <span className="text-green-500">✓</span>
                  <span><strong className="text-white">30-day money-back guarantee</strong> if less than 20% of content accessed</span>
                </li>
                <li className="flex gap-3">
                  <span className="text-green-500">✓</span>
                  <span><strong className="text-white">Technical issues:</strong> Full refund if we cannot resolve access problems</span>
                </li>
                <li className="flex gap-3">
                  <span className="text-red-500">✗</span>
                  <span><strong className="text-white">No refund:</strong> After 30 days or if more than 20% content consumed</span>
                </li>
              </ul>
            </div>
          </section>

          {/* Sponsored Challenges */}
          <section className="border-t border-gray-700 pt-8">
            <h2 className="text-2xl font-bold text-white mb-4">Sponsored Challenges</h2>
            <p className="text-gray-300 mb-4">
              Challenge sponsorship payments are <strong className="text-white">non-refundable</strong> once the challenge is live, except:
            </p>
            <ul className="space-y-2 text-gray-300">
              <li className="flex gap-2">
                <span className="text-turquoise-500">•</span>
                <span>Challenge canceled before going live (full refund)</span>
              </li>
              <li className="flex gap-2">
                <span className="text-turquoise-500">•</span>
                <span>Platform technical failure preventing challenge from running (prorated refund)</span>
              </li>
            </ul>
          </section>

          {/* Job Postings */}
          <section className="border-t border-gray-700 pt-8">
            <h2 className="text-2xl font-bold text-white mb-4">Job Board Listings</h2>
            <p className="text-gray-300">
              Paid job listings are <strong className="text-white">non-refundable</strong> once posted. 
              You may edit or remove your listing at any time, but no refunds will be issued for unused time.
            </p>
          </section>

          {/* Refund Process */}
          <section className="border-t border-gray-700 pt-8">
            <h2 className="text-2xl font-bold text-white mb-4">How to Request a Refund</h2>
            <div className="bg-gradient-to-r from-turquoise/10 to-gold/10 border border-turquoise/30 rounded-xl p-6">
              <ol className="space-y-4 text-gray-300">
                <li className="flex gap-3">
                  <span className="text-turquoise-500 font-bold">1.</span>
                  <span>Email <strong className="text-white">refunds@vibecoding.com</strong> with your order details</span>
                </li>
                <li className="flex gap-3">
                  <span className="text-turquoise-500 font-bold">2.</span>
                  <span>Include your order number, purchase date, and reason for refund</span>
                </li>
                <li className="flex gap-3">
                  <span className="text-turquoise-500 font-bold">3.</span>
                  <span>Our team will review within 2-3 business days</span>
                </li>
                <li className="flex gap-3">
                  <span className="text-turquoise-500 font-bold">4.</span>
                  <span>Approved refunds processed within 5-10 business days to original payment method</span>
                </li>
              </ol>
            </div>
          </section>

          {/* Contact */}
          <section className="border-t border-gray-700 pt-8">
            <h2 className="text-2xl font-bold text-white mb-4">Questions?</h2>
            <p className="text-gray-300 mb-4">
              If you have questions about our refund policy or need assistance:
            </p>
            <div className="bg-gray-700/50 rounded-xl p-6 border border-gray-600">
              <p className="text-gray-300">
                <strong className="text-white">Email:</strong> support@vibecoding.com
              </p>
              <p className="text-gray-300 mt-2">
                <strong className="text-white">Response Time:</strong> Within 24 hours
              </p>
            </div>
          </section>

          {/* Back to Legal */}
          <div className="border-t border-gray-700 pt-8 text-center">
            <p className="text-gray-400 mb-4">Read more about our policies:</p>
            <div className="flex gap-4 justify-center flex-wrap">
              <Link to="/terms" className="text-turquoise-500 hover:text-turquoise-400 transition-colors">
                Terms of Service
              </Link>
              <Link to="/privacy" className="text-turquoise-500 hover:text-turquoise-400 transition-colors">
                Privacy Policy
              </Link>
              <Link to="/dmca" className="text-turquoise-500 hover:text-turquoise-400 transition-colors">
                DMCA Policy
              </Link>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
};

export default RefundPolicy;
