import ModelCardsGrid from '../components/ModelCardsGrid';
import ModelList from '../components/ModelList';
import { useEffect, useState } from 'react';

function useServerModelCards() {
  const [models, setModels] = useState([]);
  useEffect(() => {
    let mounted = true;
    (async () => {
      try {
        const res = await fetch('/api/models/cards');
        if (!res.ok) throw new Error('Failed to fetch model cards');
        const data = await res.json();
        if (mounted) setModels(data || []);
      } catch (e) {
        console.warn('Failed to load /api/models/cards, falling back to empty list', e);
      }
    })();
    return () => { mounted = false; };
  }, []);
  return models;
}

export default function Showcase() {
  const models = useServerModelCards();

  return (
    <div className="min-h-screen bg-slate-900 text-gray-100 pt-20">
      <div className="max-w-7xl mx-auto px-6 sm:px-8 lg:px-12 py-12">
        <h1 className="text-4xl font-bold mb-6">Model Cards Showcase</h1>

        <section className="mb-12">
          <h2 className="text-2xl font-semibold mb-4">Premium Grid</h2>
          <ModelCardsGrid models={models} />
        </section>

        <section className="mb-12">
          <h2 className="text-2xl font-semibold mb-4">Compact List</h2>
          <ModelList models={models} />
        </section>

        <section className="mb-12">
          <h2 className="text-2xl font-semibold mb-4">Masonry</h2>
          <div className="masonry">
            {models.map((m, idx) => (
              <div key={idx} className="card glass-effect p-6">
                <h3 className="text-lg font-bold mb-2">{m.model}</h3>
                <div className="text-sm text-gray-400 mb-4">{m.creator} • {m.paramSize || '—'}</div>
                <p className="text-sm text-gray-300 mb-4">{m.description || ''}</p>
                <div className="text-sm text-gray-400">Rating: {m.rating || '—'}</div>
              </div>
            ))}
          </div>
        </section>
      </div>
    </div>
  );
}
