import { useEffect, useState } from 'react';
import { useSearchParams, Link } from 'react-router-dom';
import { FaCheckCircle, FaTrophy, FaRocket, FaUsers, FaChartLine } from 'react-icons/fa';

const SponsoredChallengeSuccess = () => {
  const [searchParams] = useSearchParams();
  const sessionId = searchParams.get('session_id');
  const [loading, setLoading] = useState(true);
  const [challengeData, setChallengeData] = useState(null);

  useEffect(() => {
    // In production, fetch actual challenge data from session
    // For now, show success message
    setTimeout(() => {
      setLoading(false);
      setChallengeData({
        company: 'Your Company',
        package: 'Professional',
        amount: 5000
      });
    }, 1500);
  }, [sessionId]);

  if (loading) {
    return (
      <div className="min-h-screen flex items-center justify-center">
        <div className="text-center">
          <div className="animate-spin rounded-full h-16 w-16 border-b-2 border-turquoise mx-auto mb-4"></div>
          <p className="text-gray-400">Processing your sponsorship...</p>
        </div>
      </div>
    );
  }

  return (
    <div className="min-h-screen pt-24 pb-12">
      <div className="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        {/* Success Header */}
        <div className="text-center mb-12">
          <div className="inline-flex items-center justify-center w-24 h-24 bg-green-500/20 rounded-full mb-6">
            <FaCheckCircle className="text-green-400 text-6xl" />
          </div>
          <h1 className="text-4xl md:text-5xl font-bold mb-4">
            🎉 Sponsorship Confirmed!
          </h1>
          <p className="text-xl text-gray-400 max-w-2xl mx-auto">
            Thank you for sponsoring a challenge on Vibe Coding Bros. Your challenge will be reviewed and published within 24 hours.
          </p>
        </div>

        {/* Payment Details */}
        <div className="card mb-8 bg-gradient-to-r from-gold/10 to-transparent border-gold/30">
          <div className="flex items-center justify-between mb-6">
            <h2 className="text-2xl font-bold">Payment Confirmation</h2>
            <FaTrophy className="text-gold text-3xl" />
          </div>
          <div className="grid md:grid-cols-3 gap-6">
            <div>
              <div className="text-sm text-gray-400 mb-1">Company</div>
              <div className="font-semibold text-lg">{challengeData?.company}</div>
            </div>
            <div>
              <div className="text-sm text-gray-400 mb-1">Package</div>
              <div className="font-semibold text-lg">{challengeData?.package}</div>
            </div>
            <div>
              <div className="text-sm text-gray-400 mb-1">Amount Paid</div>
              <div className="font-semibold text-lg text-gold">${challengeData?.amount?.toLocaleString()}</div>
            </div>
          </div>
          <div className="mt-6 pt-6 border-t border-gray-700">
            <div className="text-sm text-gray-400">
              Session ID: <code className="text-xs bg-gray-800 px-2 py-1 rounded">{sessionId || 'N/A'}</code>
            </div>
          </div>
        </div>

        {/* What Happens Next */}
        <div className="card mb-8">
          <h2 className="text-2xl font-bold mb-6">What Happens Next?</h2>
          <div className="space-y-6">
            <div className="flex gap-4">
              <div className="flex-shrink-0 w-12 h-12 bg-turquoise/20 rounded-full flex items-center justify-center">
                <span className="text-turquoise font-bold text-xl">1</span>
              </div>
              <div className="flex-1">
                <h3 className="font-semibold text-lg mb-2">Confirmation Email</h3>
                <p className="text-gray-400 text-sm">
                  You'll receive a detailed confirmation email with your payment receipt and next steps within the next few minutes.
                </p>
              </div>
            </div>

            <div className="flex gap-4">
              <div className="flex-shrink-0 w-12 h-12 bg-turquoise/20 rounded-full flex items-center justify-center">
                <span className="text-turquoise font-bold text-xl">2</span>
              </div>
              <div className="flex-1">
                <h3 className="font-semibold text-lg mb-2">Challenge Setup Call</h3>
                <p className="text-gray-400 text-sm">
                  Our team will reach out within 24 hours to schedule a kickoff call and finalize challenge details, requirements, and timeline.
                </p>
              </div>
            </div>

            <div className="flex gap-4">
              <div className="flex-shrink-0 w-12 h-12 bg-turquoise/20 rounded-full flex items-center justify-center">
                <span className="text-turquoise font-bold text-xl">3</span>
              </div>
              <div className="flex-1">
                <h3 className="font-semibold text-lg mb-2">Challenge Goes Live</h3>
                <p className="text-gray-400 text-sm">
                  After approval, your sponsored challenge will be prominently featured on our platform and promoted to our entire developer community.
                </p>
              </div>
            </div>

            <div className="flex gap-4">
              <div className="flex-shrink-0 w-12 h-12 bg-turquoise/20 rounded-full flex items-center justify-center">
                <span className="text-turquoise font-bold text-xl">4</span>
              </div>
              <div className="flex-1">
                <h3 className="font-semibold text-lg mb-2">Analytics Dashboard</h3>
                <p className="text-gray-400 text-sm">
                  Get access to your sponsor dashboard with real-time analytics, participant insights, and submission reviews.
                </p>
              </div>
            </div>
          </div>
        </div>

        {/* Your Benefits */}
        <div className="grid md:grid-cols-3 gap-6 mb-8">
          <div className="card bg-gradient-to-br from-turquoise/10 to-transparent border-turquoise/30">
            <FaUsers className="text-turquoise text-4xl mb-4" />
            <h3 className="font-bold text-lg mb-2">Reach Thousands</h3>
            <p className="text-sm text-gray-400">
              Your challenge will be featured to 10,000+ active developers
            </p>
          </div>

          <div className="card bg-gradient-to-br from-gold/10 to-transparent border-gold/30">
            <FaTrophy className="text-gold text-4xl mb-4" />
            <h3 className="font-bold text-lg mb-2">Top Talent Access</h3>
            <p className="text-sm text-gray-400">
              Connect directly with challenge winners and high-performers
            </p>
          </div>

          <div className="card bg-gradient-to-br from-purple/10 to-transparent border-purple/30">
            <FaChartLine className="text-purple text-4xl mb-4" />
            <h3 className="font-bold text-lg mb-2">Real-time Analytics</h3>
            <p className="text-sm text-gray-400">
              Track engagement, submissions, and community metrics
            </p>
          </div>
        </div>

        {/* Quick Actions */}
        <div className="card bg-gray-800">
          <div className="flex flex-col md:flex-row items-center justify-between gap-6">
            <div>
              <h3 className="text-xl font-bold mb-2">Ready to Get Started?</h3>
              <p className="text-gray-400 text-sm">
                View all challenges or contact our team for immediate assistance
              </p>
            </div>
            <div className="flex gap-3">
              <Link to="/challenges" className="btn-primary flex items-center gap-2">
                <FaRocket /> View Challenges
              </Link>
              <a 
                href="mailto:sponsor@vibecoding.com" 
                className="btn-secondary flex items-center gap-2"
              >
                Contact Support
              </a>
            </div>
          </div>
        </div>

        {/* Receipt Notice */}
        <div className="mt-8 p-4 bg-blue-500/10 border border-blue-500/30 rounded-lg text-center">
          <p className="text-sm text-blue-300">
            💌 A detailed receipt has been sent to your email. Check your inbox (and spam folder) for confirmation.
          </p>
        </div>
      </div>
    </div>
  );
};

export default SponsoredChallengeSuccess;
