import React, { useEffect } from 'react';
import { useNavigate, useSearchParams } from 'react-router-dom';
import { FaCheckCircle } from 'react-icons/fa';

const SubscriptionSuccess = () => {
  const navigate = useNavigate();
  const [searchParams] = useSearchParams();

  useEffect(() => {
    // Optionally verify session with backend
    const sessionId = searchParams.get('session_id');
    if (!sessionId) {
      navigate('/pricing');
    }
  }, [searchParams, navigate]);

  return (
    <div className="min-h-screen px-4 py-20">
      <div className="max-w-2xl mx-auto text-center">
        {/* Success Icon */}
        <div className="mb-8">
          <FaCheckCircle className="text-6xl text-green-500 mx-auto mb-4" />
          <h1 className="text-4xl font-bold mb-4">
            Subscription <span className="text-gradient">Activated!</span>
          </h1>
          <p className="text-xl text-gray-400">
            Welcome to your new subscription tier. You now have access to all premium features.
          </p>
        </div>

        {/* Features */}
        <div className="card p-8 mb-8">
          <h2 className="text-2xl font-bold mb-6">What's Next?</h2>
          <div className="text-left space-y-4">
            <div className="flex items-start gap-3">
              <span className="text-turquoise text-xl">✓</span>
              <div>
                <h3 className="font-medium mb-1">Explore Premium Features</h3>
                <p className="text-sm text-gray-400">
                  Access advanced challenges, analytics, and exclusive content
                </p>
              </div>
            </div>
            <div className="flex items-start gap-3">
              <span className="text-turquoise text-xl">✓</span>
              <div>
                <h3 className="font-medium mb-1">Customize Your Experience</h3>
                <p className="text-sm text-gray-400">
                  Set up your profile and preferences in the dashboard
                </p>
              </div>
            </div>
            <div className="flex items-start gap-3">
              <span className="text-turquoise text-xl">✓</span>
              <div>
                <h3 className="font-medium mb-1">Join the Community</h3>
                <p className="text-sm text-gray-400">
                  Connect with other premium members and creators
                </p>
              </div>
            </div>
          </div>
        </div>

        {/* Action Buttons */}
        <div className="flex flex-col sm:flex-row gap-4 justify-center">
          <button
            onClick={() => navigate('/dashboard')}
            className="btn-primary"
          >
            Go to Dashboard
          </button>
          <button
            onClick={() => navigate('/marketplace')}
            className="btn-secondary"
          >
            Browse Marketplace
          </button>
        </div>

        {/* Manage Subscription */}
        <p className="text-sm text-gray-500 mt-8">
          You can manage your subscription anytime from your dashboard or settings.
        </p>
      </div>
    </div>
  );
};

export default SubscriptionSuccess;
