import { Link } from 'react-router-dom';

const Terms = () => {
  return (
    <div className="min-h-screen bg-gray-900 py-12">
      <div className="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="bg-gray-800 rounded-lg shadow-xl p-8">
          <h1 className="text-4xl font-bold text-gradient mb-4">Terms of Service</h1>
          <p className="text-gray-400 mb-8">Last updated: November 9, 2025</p>

          <div className="prose prose-invert max-w-none">
            <section className="mb-8">
              <h2 className="text-2xl font-semibold text-white mb-4">1. Agreement to Terms</h2>
              <p className="text-gray-300 mb-4">
                By accessing or using VibeCodingBros ("the Platform"), you agree to be bound by these Terms of Service ("Terms"). If you disagree with any part of these terms, you may not access the Platform.
              </p>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-semibold text-white mb-4">2. Description of Service</h2>
              <p className="text-gray-300 mb-4">
                VibeCodingBros is a developer community platform that provides:
              </p>
              <ul className="list-disc list-inside text-gray-300 mb-4 space-y-2">
                <li>Workflow sharing and tutorials</li>
                <li>Coding challenges and competitions</li>
                <li>Job board and talent marketplace</li>
                <li>Template and component marketplace</li>
                <li>Real-time messaging and collaboration</li>
                <li>Event hosting and community features</li>
              </ul>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-semibold text-white mb-4">3. User Accounts</h2>
              
              <h3 className="text-xl font-semibold text-white mb-3">3.1 Account Creation</h3>
              <ul className="list-disc list-inside text-gray-300 mb-4 space-y-2">
                <li>You must be at least 13 years old to use the Platform</li>
                <li>You must provide accurate, complete, and current information</li>
                <li>You are responsible for maintaining account security</li>
                <li>One account per person (no multiple accounts)</li>
                <li>You must not impersonate others</li>
              </ul>

              <h3 className="text-xl font-semibold text-white mb-3">3.2 Account Termination</h3>
              <p className="text-gray-300 mb-4">
                We reserve the right to suspend or terminate accounts that violate these Terms, engage in abusive behavior, or for any other reason at our sole discretion.
              </p>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-semibold text-white mb-4">4. User Content</h2>
              
              <h3 className="text-xl font-semibold text-white mb-3">4.1 Your Content</h3>
              <p className="text-gray-300 mb-4">
                You retain ownership of content you post. By posting, you grant us a worldwide, non-exclusive, royalty-free license to use, reproduce, modify, and display your content for platform operation.
              </p>

              <h3 className="text-xl font-semibold text-white mb-3">4.2 Content Restrictions</h3>
              <p className="text-gray-300 mb-4">You may not post content that:</p>
              <ul className="list-disc list-inside text-gray-300 mb-4 space-y-2">
                <li>Violates intellectual property rights</li>
                <li>Contains malware, viruses, or malicious code</li>
                <li>Is illegal, harmful, threatening, abusive, or discriminatory</li>
                <li>Contains spam or unsolicited commercial content</li>
                <li>Impersonates others or misrepresents affiliation</li>
                <li>Violates privacy rights of others</li>
                <li>Is sexually explicit or pornographic</li>
                <li>Promotes violence or illegal activities</li>
              </ul>

              <h3 className="text-xl font-semibold text-white mb-3">4.3 Content Moderation</h3>
              <p className="text-gray-300 mb-4">
                We reserve the right (but have no obligation) to monitor, review, and remove content that violates these Terms or is otherwise objectionable.
              </p>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-semibold text-white mb-4">5. Marketplace Terms</h2>
              
              <h3 className="text-xl font-semibold text-white mb-3">5.1 Seller Responsibilities</h3>
              <ul className="list-disc list-inside text-gray-300 mb-4 space-y-2">
                <li>You must have rights to sell the content you list</li>
                <li>Products must be accurately described</li>
                <li>You must provide reasonable support for paid products</li>
                <li>You agree to the 70/30 revenue share (70% to seller, 30% platform fee)</li>
              </ul>

              <h3 className="text-xl font-semibold text-white mb-3">5.2 Buyer Responsibilities</h3>
              <ul className="list-disc list-inside text-gray-300 mb-4 space-y-2">
                <li>Purchases are final (no refunds except as required by law)</li>
                <li>You receive a license to use, not ownership</li>
                <li>You may not redistribute purchased items</li>
                <li>Review products before purchasing when previews available</li>
              </ul>

              <h3 className="text-xl font-semibold text-white mb-3">5.3 Disputes</h3>
              <p className="text-gray-300 mb-4">
                Disputes between buyers and sellers should be resolved directly. We may mediate but are not obligated to do so.
              </p>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-semibold text-white mb-4">6. Subscription Services</h2>
              
              <h3 className="text-xl font-semibold text-white mb-3">6.1 Subscription Tiers</h3>
              <ul className="list-disc list-inside text-gray-300 mb-4 space-y-2">
                <li><strong>Free:</strong> Basic access to platform features</li>
                <li><strong>Pro ($19/month):</strong> Enhanced features and analytics</li>
                <li><strong>Creator ($49/month):</strong> Full monetization capabilities</li>
              </ul>

              <h3 className="text-xl font-semibold text-white mb-3">6.2 Billing</h3>
              <ul className="list-disc list-inside text-gray-300 mb-4 space-y-2">
                <li>Subscriptions auto-renew monthly or annually</li>
                <li>Payment processed through Stripe</li>
                <li>You can cancel anytime (no refunds for partial months)</li>
                <li>Price changes will be communicated 30 days in advance</li>
              </ul>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-semibold text-white mb-4">7. Job Posting Terms</h2>
              <ul className="list-disc list-inside text-gray-300 mb-4 space-y-2">
                <li>Job postings must be for legitimate positions</li>
                <li>No multi-level marketing or commission-only positions</li>
                <li>Must comply with employment laws</li>
                <li>No discrimination in job listings</li>
                <li>Job postings expire after duration purchased</li>
              </ul>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-semibold text-white mb-4">8. Challenge Terms</h2>
              <ul className="list-disc list-inside text-gray-300 mb-4 space-y-2">
                <li>Challenge submissions must be original work</li>
                <li>Winners selected based on stated criteria</li>
                <li>Prizes paid within 30 days of challenge completion</li>
                <li>Challenge sponsors may showcase winning submissions</li>
                <li>Cheating or plagiarism results in disqualification and ban</li>
              </ul>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-semibold text-white mb-4">9. Intellectual Property</h2>
              
              <h3 className="text-xl font-semibold text-white mb-3">9.1 Platform IP</h3>
              <p className="text-gray-300 mb-4">
                The Platform, including design, features, code, and trademarks, is owned by VibeCodingBros and protected by copyright, trademark, and other laws.
              </p>

              <h3 className="text-xl font-semibold text-white mb-3">9.2 DMCA Policy</h3>
              <p className="text-gray-300 mb-4">
                If you believe content infringes your copyright, contact us at dmca@vibecodingbros.com with:
              </p>
              <ul className="list-disc list-inside text-gray-300 mb-4 space-y-2">
                <li>Description of copyrighted work</li>
                <li>Location of infringing content</li>
                <li>Your contact information</li>
                <li>Good faith statement of unauthorized use</li>
                <li>Statement of accuracy under penalty of perjury</li>
                <li>Physical or electronic signature</li>
              </ul>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-semibold text-white mb-4">10. Prohibited Activities</h2>
              <p className="text-gray-300 mb-4">You may not:</p>
              <ul className="list-disc list-inside text-gray-300 mb-4 space-y-2">
                <li>Violate laws or regulations</li>
                <li>Abuse, harass, threaten, or intimidate others</li>
                <li>Spam or send unsolicited messages</li>
                <li>Scrape or data mine the Platform</li>
                <li>Reverse engineer or decompile the Platform</li>
                <li>Bypass security measures or rate limits</li>
                <li>Use bots or automated tools without permission</li>
                <li>Attempt to gain unauthorized access</li>
                <li>Interfere with platform operation</li>
                <li>Create fake accounts or manipulate metrics</li>
              </ul>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-semibold text-white mb-4">11. Disclaimers</h2>
              
              <h3 className="text-xl font-semibold text-white mb-3">11.1 "As Is" Service</h3>
              <p className="text-gray-300 mb-4">
                THE PLATFORM IS PROVIDED "AS IS" WITHOUT WARRANTIES OF ANY KIND, EXPRESS OR IMPLIED. WE DO NOT GUARANTEE UNINTERRUPTED, ERROR-FREE, OR SECURE ACCESS.
              </p>

              <h3 className="text-xl font-semibold text-white mb-3">11.2 Third-Party Content</h3>
              <p className="text-gray-300 mb-4">
                We are not responsible for user-generated content or third-party services. You use them at your own risk.
              </p>

              <h3 className="text-xl font-semibold text-white mb-3">11.3 No Employment Guarantee</h3>
              <p className="text-gray-300 mb-4">
                Job postings are provided by third parties. We do not guarantee employment, earnings, or opportunity legitimacy.
              </p>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-semibold text-white mb-4">12. Limitation of Liability</h2>
              <p className="text-gray-300 mb-4">
                TO THE MAXIMUM EXTENT PERMITTED BY LAW, VIBECODINGBROS SHALL NOT BE LIABLE FOR:
              </p>
              <ul className="list-disc list-inside text-gray-300 mb-4 space-y-2">
                <li>Indirect, incidental, special, or consequential damages</li>
                <li>Loss of profits, data, or goodwill</li>
                <li>Service interruptions or errors</li>
                <li>User content or third-party actions</li>
                <li>Unauthorized access to your account</li>
              </ul>
              <p className="text-gray-300 mb-4">
                OUR TOTAL LIABILITY SHALL NOT EXCEED THE AMOUNT YOU PAID US IN THE PAST 12 MONTHS, OR $100, WHICHEVER IS GREATER.
              </p>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-semibold text-white mb-4">13. Indemnification</h2>
              <p className="text-gray-300 mb-4">
                You agree to indemnify and hold harmless VibeCodingBros from claims, damages, and expenses arising from:
              </p>
              <ul className="list-disc list-inside text-gray-300 mb-4 space-y-2">
                <li>Your use of the Platform</li>
                <li>Your content or conduct</li>
                <li>Violation of these Terms</li>
                <li>Violation of third-party rights</li>
              </ul>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-semibold text-white mb-4">14. Dispute Resolution</h2>
              
              <h3 className="text-xl font-semibold text-white mb-3">14.1 Governing Law</h3>
              <p className="text-gray-300 mb-4">
                These Terms are governed by the laws of [Your State/Country], without regard to conflict of law principles.
              </p>

              <h3 className="text-xl font-semibold text-white mb-3">14.2 Arbitration</h3>
              <p className="text-gray-300 mb-4">
                Disputes shall be resolved through binding arbitration, except you may bring claims in small claims court if eligible.
              </p>

              <h3 className="text-xl font-semibold text-white mb-3">14.3 Class Action Waiver</h3>
              <p className="text-gray-300 mb-4">
                You waive the right to bring claims as a class action, private attorney general action, or representative action.
              </p>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-semibold text-white mb-4">15. Changes to Terms</h2>
              <p className="text-gray-300 mb-4">
                We may update these Terms at any time. Material changes will be notified via email or prominent platform notice. Continued use after changes constitutes acceptance.
              </p>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-semibold text-white mb-4">16. Termination</h2>
              <p className="text-gray-300 mb-4">
                Either party may terminate this agreement at any time. Upon termination:
              </p>
              <ul className="list-disc list-inside text-gray-300 mb-4 space-y-2">
                <li>Your access to the Platform will cease</li>
                <li>Content may be removed (download before closing account)</li>
                <li>Outstanding payments remain due</li>
                <li>Provisions that should survive (liability, indemnification) remain in effect</li>
              </ul>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-semibold text-white mb-4">17. Miscellaneous</h2>
              <ul className="list-disc list-inside text-gray-300 mb-4 space-y-2">
                <li><strong>Entire Agreement:</strong> These Terms constitute the entire agreement</li>
                <li><strong>Severability:</strong> Invalid provisions don't affect remaining terms</li>
                <li><strong>Waiver:</strong> Failure to enforce doesn't waive rights</li>
                <li><strong>Assignment:</strong> You may not assign these Terms; we may assign freely</li>
                <li><strong>No Agency:</strong> No partnership, joint venture, or agency created</li>
              </ul>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-semibold text-white mb-4">18. Contact Information</h2>
              <p className="text-gray-300 mb-4">
                Questions about these Terms? Contact us:
              </p>
              <ul className="list-none text-gray-300 mb-4 space-y-2">
                <li><strong>Email:</strong> legal@vibecodingbros.com</li>
                <li><strong>Support:</strong> support@vibecodingbros.com</li>
                <li><strong>Website:</strong> vibecodingbros.com</li>
              </ul>
            </section>
          </div>

          <div className="mt-8 pt-8 border-t border-gray-700">
            <Link to="/" className="text-turquoise hover:text-turquoise-light transition-colors">
              ← Back to Home
            </Link>
          </div>
        </div>
      </div>
    </div>
  );
};

export default Terms;
