// Google Analytics utility functions

export const pageview = (url) => {
  if (typeof window.gtag !== 'undefined') {
    window.gtag('config', 'G-F8JZFPHQHP', {
      page_path: url,
    });
  }
};

export const event = ({ action, category, label, value }) => {
  if (typeof window.gtag !== 'undefined') {
    window.gtag('event', action, {
      event_category: category,
      event_label: label,
      value: value,
    });
  }
};

// Predefined events for common actions
export const trackSignup = (method) => {
  event({
    action: 'sign_up',
    category: 'engagement',
    label: method,
  });
};

export const trackLogin = (method) => {
  event({
    action: 'login',
    category: 'engagement',
    label: method,
  });
};

export const trackPurchase = (productId, value, currency = 'USD') => {
  if (typeof window.gtag !== 'undefined') {
    window.gtag('event', 'purchase', {
      transaction_id: Date.now().toString(),
      value: value,
      currency: currency,
      items: [
        {
          item_id: productId,
          item_name: 'Product Purchase',
        },
      ],
    });
  }
};

export const trackSubscription = (tier, value) => {
  event({
    action: 'subscribe',
    category: 'conversion',
    label: tier,
    value: value,
  });
};

export const trackJobPost = (tier, value) => {
  event({
    action: 'post_job',
    category: 'conversion',
    label: tier,
    value: value,
  });
};

export const trackChallengeSponsor = (tier, value) => {
  event({
    action: 'sponsor_challenge',
    category: 'conversion',
    label: tier,
    value: value,
  });
};

export const trackSearch = (query) => {
  event({
    action: 'search',
    category: 'engagement',
    label: query,
  });
};

export const trackShare = (contentType, contentId) => {
  event({
    action: 'share',
    category: 'engagement',
    label: `${contentType}_${contentId}`,
  });
};

export const trackViewContent = (contentType, contentId) => {
  if (typeof window.gtag !== 'undefined') {
    window.gtag('event', 'view_item', {
      content_type: contentType,
      content_id: contentId,
    });
  }
};
